package chess4j.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import chess4j.App;
import chess4j.io.DrawBoard;
import chess4j.io.FenParser;
import chess4j.io.MoveParser;
import chess4j.moves.Move;
import chess4j.search.SearchIterator;
import chess4j.search.SearchStats;


public class TestSuite {
		
	public static void process(File f) throws FileNotFoundException {
		BufferedReader in = new BufferedReader(new FileReader(f));
		String line = null;
        int cntLine=0,nCorrect=0,nProblems=0;
        long totalNodes=0, totalTime=0;
        List<Move> solutions = new ArrayList<Move>();
        try {
			while ((line = in.readLine()) != null) {
				System.out.println("====================================");
			    System.out.println(++cntLine + " " + line);
				String remaining=FenParser.setPos(App.getBoard(), line);
				System.out.println("remaining: " + remaining);
				DrawBoard.drawBoard(App.getBoard());
				assert(remaining.startsWith("bm "));
				String[] strSolutions = remaining.substring(3,remaining.indexOf(';')).split(" ");
				assert(strSolutions.length>0);
				solutions.clear();
				for (int i=0;i<strSolutions.length;i++) {
					System.out.println("\tsolution #" + (i+1) + ": " + strSolutions[i]);
					Move mv = MoveParser.parseLegalMove(strSolutions[i], App.getBoard());
					System.out.println("\tparsed: " + mv + "\n");
					solutions.add(mv);
				}
				long start = System.currentTimeMillis();
				Thread t = new Thread(SearchIterator.getInstance());
				t.start();
				t.join();
				long time = System.currentTimeMillis() - start;
				totalTime += time;
				nProblems++;				
				Move m = SearchIterator.getInstance().getLastPV().get(0);
				if (solutions.contains(m)) {
					nCorrect++;
					System.out.println("\nCORRECT! (" + nCorrect + "/" + nProblems + ")");
				} else {
					System.out.println("\nINCORRECT! (" + nCorrect + "/" + nProblems + ")");
				}
				SearchStats stats = SearchIterator.getInstance().getLastSearchStats();
				long nodes = stats.getNodes();
				long hashProbes = stats.getHashProbes();
				long hashHits = stats.getHashHits();
				totalNodes += nodes;
				System.out.print("nodes: " + nodes);
				System.out.print(", time: " + time + " ms");
				System.out.println(", n/s: " + nodes*1000/(time+1)); // avoid div by 0
				DecimalFormat df = new DecimalFormat("0.00");
				System.out.println("hash probes: " + hashProbes + ", hits: " + hashHits + " (" + 
						df.format(new Double(hashHits)*100/(hashProbes+1)) + "%)");
			}
			
			System.out.println("======================================================");
			System.out.println("attempted: " + nProblems + "; correct=" + nCorrect);
			System.out.print("nodes: " + totalNodes);
			System.out.print(", time: " + totalTime + " ms");
			System.out.println(", n/s: " + totalNodes*1000/(totalTime+1)); // avoid div by 0
			System.out.println("======================================================");
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}
}
